
markup.push(
{

// MARK: templates window

EditorUpsellWindow:
{
	nsClass: "GXWindow",
	gxInitialWindowSize: "570, 300",     // for initial positioning
	gxInitialWindowPosition: "0.5, 0.6",
	gxWindowTitle: "Set Your Audio Editor",
	//gxBackColor: "BackColor1",
	gxContentView: "EditorUpsellContentView",
},

// --------------------------------------------------------
// MARK: - editor upsell popover

EditorUpsellContentView:
{
	nsClass: "GXDrawView",
	gxTitle: "Pass Files to:",
	gxLayout: [
		"H:[self(570)]",
		"V:[titleBarView(26)]-0-[background]-0-|",
	],
	gxChildViews:
	{
		titleBarView:
		{
			"+": "TitleBarView",
			gxChildViews:
			{
				windowTitle: {
					"+": "WindowTitle.foreColor1.size14",
					gxDefaultValue: "Set Your Audio Editor",
				},
			},
		},
		background: {
			nsClass: "GXDrawView",
			gxBackPainter: "GroupViewBack",
			gxLayout:
			[
				"H:|-0-[self]-0-|",

				"V:|-18-[editorText(40)]-10-[prefsBtn(24)]-18-[divider(1)]-18-[fissionText(81)]-(-6)-[fissionBtn(24)]-17-|",

				"H:|-14-[editorIcon(70)]-14-[editorText]-14-|",
				"V:|-20-[editorIcon(64)]",		// smaller than fission icon to be visually similar
				"H:[prefsBtn(160)]-14-|",

				"H:|-0-[divider]-0-|",
					   
				"H:|-14-[fissionIcon(70)]-14-[fissionText]-18-|",
				"V:[divider]-18-[fissionIcon(70)]",		// larger than editor icon
				"H:[fissionBtn(160)]-14-|",
			],
			gxChildViews:
			{
				editorIcon: {
					nsClass: "GXDrawView",
					gxBackPainter: "ImagePainter.foreColor1.genericEditor"
				},
				editorText: {
					"+": "LabelView.useMarkup.lineSpacing2.top.left.foreColor1.size135",
					gxDefaultValue: "Audio Hijack can send recordings directly to your desired audio editor.\nJust adjust the “Audio Editor” setting in the Preferences window."
				},
				prefsBtn: {
					"+": "ButtonView.on",
					gxTitle: "Open Preferences…",
					gxValueKey: "preferencesBtn"
				},
				divider: filledView("BackColor3"),
				fissionIcon: {
					nsClass: "GXDrawView",
					gxBackPainter: "ImagePainter.fissionIcon"
				},
				fissionText: {
					"+": "LabelView.useMarkup.lineSpacing2.top.left.wrap.foreColor1.size135",
					gxDefaultValue: "<boldWeight>Don't Have an Audio Editor?</boldWeight>\nWe recommend our own easy-to-use audio editor Fission. Crop and trim audio, join files, or just rapidly split one long file into many – all with no quality loss!"
				},
				fissionBtn: {
					"+": "ButtonView",
					gxTitle: "Learn about Fission…",
					gxIconBaseName: "fission.icon",
					gxValueKey: "fissionBtn"
				}
			}
		}
	}
},

})
